<?php get_header(); ?>

<?php
	if ( isset( $wp_query->query_vars[ 'open_feature' ] ) ) {
		switch ( $wp_query->query_vars[ 'open_feature' ] ) {
			case 'hours':
				require( 'hours.php' );
				break;
			case 'location':
				require( 'location.php' );
				break;
		}
	} else {
?>

	<?php
		$open_settings = open_get_settings();
		if ( $open_settings->show_hours ) {
	?>
	<aside id="openclosed">
		<?php
			$today = date( 'l', current_time( 'timestamp' ) );
			$todays_hours = $open_settings->{ 'hours_' . strtolower( $today ) };
			if ( $todays_hours ) {
				echo sprintf( __( 'We&lsquo;re <em>open</em> every %s %s.' ), $today, $todays_hours );
			} else {
				echo sprintf( __( 'Sorry, we&lsquo;re <em>closed</em> every %s.' ), $today );
			}

		?>
	</aside>
	<?php
		}
	?>

	<div id="content">
		<?php open_homepage_content(); ?>

		<?php if ( wptouch_has_menu( 'primary_menu' ) ) { ?>
			<nav id="homepage-menu-list" class="homepage-menu show-hide-menu">
				<?php wptouch_show_menu( 'primary_menu' ); ?>
			</nav>
		<?php } ?>

	</div><!-- #content -->

<?php
	}
?>

<?php get_footer(); ?>