<?php
/**
 * Yellow Pages Settings
 */
function ypr_get_settings() {
	$yellow_pages_reviews_options = array(
		array( 'name' => __( 'About', 'ypr' ), 'type' => 'opentab' ),
		array( 'type' => 'about' ),
		array(
			'name'  => __( 'Yellow Pages API Key', 'ypr' ),
			'desc'  => sprintf( __( 'API keys are managed through the <a href="%1$s" class="new-window" target="_blank" class="new-window">Yellow Pages Publisher Center</a>. Sign up is FREE and will provide you access to <a href="%2$s" target="_blank" class="new-window" title="Generate an API Key">generate an API Key</a> once registered. For further instructions please see this <a href="%3$s" target="_blank" class="new-window" title="How to obtain a YP API Key">helpful article</a>.', 'ypr' ), 'https://publisher.yp.com/register', 'https://publisher.yp.com/account/sites-apps', 'https://wordimpress.com/docs/yellow-pages-reviews/#obtaining-a-yellow-pages-api-key' ),
			'std'   => '',
			'id'    => 'yellow_pages_api_key',
			'type'  => 'text',
			'label' => __( 'Yes', 'ypr' )
		),

		array( 'type' => 'closetab', 'actions' => true ),

		//Advanced Options
		array(
			'name' => __( 'Advanced Options', 'ypr' ),
			'type' => 'opentab'
		),
		array(
			'name'  => __( 'Disable Plugin CSS', 'ypr' ),
			'desc'  => __( 'Useful to style your own widget and for theme integration and optimization.', 'ypr' ),
			'std'   => '',
			'id'    => 'disable_css',
			'type'  => 'checkbox',
			'label' => __( 'Yes', 'ypr' )
		),
		array( 'type' => 'closetab', 'actions' => true ),

		//Bundle
		array( 'name' => __( 'Get More Reviews', 'ypr' ), 'type' => 'opentab' ),
		array( 'type' => 'bundle' ),
		array( 'type' => 'closetab' ),
	);

	return $yellow_pages_reviews_options;
}
