<?php
/*
Plugin Name: AOW - Central Author Plugin
Plugin URI: http://aheadoftheweb.com/
Description: Ensures that all pages/posts have the same author.
Author: Ahead of the Web
Author URI: http://aheadoftheweb.com
Version: 1.1
*/

/**
 * Setup native automatic theme update functionality
 */
require 'update-checker/plugin-update-checker.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	'https://updates.aheadoftheweb.com/?action=get_metadata&slug=aow_author',
	__FILE__,
	'aow_author'
);


if (!function_exists('aow')):
function aow()
{
	$plugin_base = get_home_path()."wp-content/plugins/";

	echo "<h2>Ahead of the Web Plugins</h2>
	<hr />";
?>
	<ul>
    <li>AOW - Central Author Plugin - <?php if (is_plugin_active('aow_author/aow_author.php')): ?> <strong>Active</strong> <?php elseif (is_plugin_inactive('aow_author/aow_author.php') && is_dir($plugin_base."aow_author")): ?> <strong>Inactive</strong> <?php else: ?><strong>Not installed</strong> <?php endif; ?></li>
    <li>AOW - Hours of Business Plugin - <?php if (is_plugin_active('aow_contentshare-child/aow_contentshare-child.php')): ?> <strong>Active</strong> <?php elseif (is_plugin_inactive('aow_contentshare-child/aow_contentshare-child.php') && is_dir($plugin_base."aow_contentshare-child")): ?> <strong>Inactive</strong> <?php else: ?><strong>Not installed</strong> <?php endif; ?> </li>
    <li>AOW - Links Plugin - <?php if (is_plugin_active('aow_hub_links/aow_hub_links.php')): ?> <strong>Active</strong> <?php elseif (is_plugin_inactive('aow_hub_links/aow_hub_links.php') && is_dir($plugin_base."aow_hub_links")): ?> <strong>Inactive</strong> <?php else: ?><strong>Not installed</strong> <?php endif; ?></li>
    <li>AOW - Promotion Plugin - <?php if (is_plugin_active('aow_hub_promo/aow_hub_promo.php')): ?> <strong>Active</strong> <?php elseif (is_plugin_inactive('aow_hub_promo/aow_hub_promo.php') && is_dir($plugin_base."aow_hub_promo")): ?> <strong>Inactive</strong> <?php else: ?><strong>Not installed</strong> <?php endif; ?> </li>
    <li>AOW - Referral Promotion Plugin - <?php if (is_plugin_active('aow_referral_promotion/aow_referral_promotion.php')): ?> <strong>Active</strong> <?php elseif (is_plugin_inactive('aow_referral_promotion/aow_referral_promotion.php') && is_dir($plugin_base."aow_referral_promotion")): ?> <strong>Inactive</strong> <?php else: ?><strong>Not installed</strong> <?php endif; ?></li>
    <li>AOW - Security Plugin - <?php if (is_plugin_active('aow_security/aow_security.php')): ?> <strong>Active</strong> <?php elseif (is_plugin_inactive('aow_security/aow_security.php') && is_dir($plugin_base."aow_security")): ?> <strong>Inactive</strong> <?php else: ?><strong>Not installed</strong> <?php endif; ?></li>
    <li>AOW - Testimonials Plugin - <?php if (is_plugin_active('aow_testimonial/aow_testimonial.php')): ?> <strong>Active</strong> <?php elseif (is_plugin_inactive('aow_testimonial/aow_testimonial.php') && is_dir($plugin_base."aow_testimonial")): ?> <strong>Inactive</strong> <?php else: ?><strong>Not installed</strong> <?php endif; ?></li>
    </ul>
<?php
}
endif;

add_action( 'admin_menu', 'author_menu_items' );

function author_menu_items(){
		if (empty($GLOBALS['admin_page_hooks']['aow'])):
			add_menu_page('AOW Plugins', 'AOW Plugins', 'update_plugins', 'aow', 'aow','dashicons-admin-plugins');
		endif;
	add_submenu_page( 'aow', 'Author Management', 'Author Management', 'manage_options', 'author-admin', 'author_admin' );	
	add_submenu_page('author-admin', 'About', 'About', 'manage_options', 'author-about', 'author_about');
}

function author_admin()
{
	global $wpdb;
	
	$post_authors = $wpdb->get_results("SELECT * FROM wp_users");
	$author_setting = get_option("author_setting");
	$action = $_POST['action'];
	
	if ($action == "Update Author Settings"):
		$authorid = $_POST['post_author'];
		update_option("author_setting",$authorid);
		$author_setting = get_option("author_setting");
		$wpdb->query("UPDATE wp_posts SET post_author='".$wpdb->escape($authorid)."'");
	endif;
?>
<ul class="subsubsub">
<li><a href="<?php echo admin_url('admin.php?page=author-admin'); ?>"><strong>Author Home</strong></a> |</li>
<li><a href="<?php echo admin_url('admin.php?page=author-about'); ?>"><strong>Author About</strong></a></li>
    </ul><br /><br />
    <hr />

<strong>Currently Set Author:</strong> 
<?php if ($author_setting === false): echo "None"; else:
$userinfo = get_userdata($author_setting);
echo $userinfo->display_name;
endif;
?>
<form action="<?php echo admin_url('admin.php?page=author-admin'); ?>" method="post">
<select name="post_author">
	<?php foreach ($post_authors as $author):?>
	<option value="<?php echo $author->ID; ?>" <?php if ($author_setting !== false && $author->ID == $author_setting): ?> selected <?php endif; ?>><?php echo $author->display_name; ?></option>
	<?php endforeach; ?>
</select>
<input type="submit" value="Update Author Settings" name="action" class="button" />
</form>

<?php
}

function author_about()
{
	?>
    
<ul class="subsubsub">
<li><a href="<?php echo admin_url('admin.php?page=author-admin'); ?>"><strong>Author Home</strong></a> |</li>
<li><a href="<?php echo admin_url('admin.php?page=author-about'); ?>"><strong>Author About</strong></a></li>
    </ul><br /><br />
    <hr />
<p>This plugin automatically sets the author of any post or page you create or update to the one you set on the home page of this plugin.</p>
<?php
}

function aow_author_save_post($post_id)
{
	if (! wp_is_post_revision($post_id)):
		remove_action('save_post', 'aow_author_save_post');
		$author_setting = get_option("author_setting");
		
		if ($author_setting !== FALSE):
			$args = array('ID' => $post_id, 'post_author' => $author_setting);
			wp_update_post($args);
		endif;
		add_action('save_post', 'aow_author_save_post');
	endif;	
}
add_action('save_post', 'aow_author_save_post');