<?php
/**
 * The Header template for our theme
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Thirteen
 * @since Twenty Thirteen 1.0
 */
?><!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<title><?php wp_title( '|', true, 'right' ); ?></title>
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<!--[if lt IE 9]>
	<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js"></script>
	<![endif]-->
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div id="page" class="hfeed site">
		<header id="masthead" class="site-header" role="banner">
    <div id="header"><div id="leftheader"><img src="/wp-content/themes/georgia-2013-child/images/logo.gif" alt="Vancouver Cosmetic Dental" width="68" height="70" class="fltlt" />
    <p class="dentalgroup">Georgia Dental Group</p>
    <p>Vancouver Cosmetic Dental | Dr. Brian Baird, DMD</p></div>
    <div id="rightheader">
      <p class="dentalgroup"><a href="/contact-us/book-appointment-online/"><img src="/wp-content/themes/georgia-2013-child/images/appt.gif" alt="Make an Appointment" width="173" height="29" class="fltrt" /></a> <a href="tel:6046847745" class="phone">604-684-7745</a></p>
    <p class="clear">Suite 530, 1090 West Georgia Street &middot; Vancouver &middot; BC &middot; V6E 3V7<br /><br>
      <strong style="font-size:1.1em;">New Patients Welcome!</strong> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; Follow Us on Facebook <a href="http://www.facebook.com/pages/Georgia-Dental/164366310271881" title="Find us on Facebook" target="_blank"><img src="/wp-content/themes/georgia-2013-child/images/facebook.png" width="25" height="25" alt="Find us on Facebook" /></a> </p></div>

			<div id="navbar" class="navbar">
				<nav id="site-navigation" class="navigation main-navigation" role="navigation">
					<h3 class="menu-toggle"><?php _e( 'Menu', 'twentythirteen' ); ?></h3>
					<a class="screen-reader-text skip-link" href="#content" title="<?php esc_attr_e( 'Skip to content', 'twentythirteen' ); ?>"><?php _e( 'Skip to content', 'twentythirteen' ); ?></a>
					<?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu' ) ); ?>
				</nav><!-- #site-navigation -->
			</div><!-- #navbar -->
            </div><!-- #header -->
		</header><!-- #masthead -->

		<div id="main" class="site-main">
